# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY WYMAGANE
# Konieczne jest podanie wartości dla każdego z tych parametrów.
# ---------------------------------------------------------------------------------------------------------------------

variable "db_username" {
  description = "Nazwa użytkownika bazy danych"
  type        = string
  sensitive   = true
}
variable "db_password" {
  description = "Hasło do bazy danych"
  type        = string
  sensitive   = true
}

# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "server_text" {
  description = "Ciąg tekstowy zwracany przez serwer"
  default     = "Witaj, świecie"
  type        = string
}

variable "environment" {
  description = "Nazwa środowiska, w którym będzie przeprowadzone wdrożenie"
  type        = string
  default     = "example"
}

variable "db_name" {
  description = "Nazwa bazy danych, która ma być użyta"
  type        = string
  default     = "example_database"
}
